// Check if user is logged in
function isLoggedIn() {
    return sessionStorage.getItem('userId') !== null;
}

// Handle login
document.getElementById('loginForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const email = document.getElementById('email').value;
    const password = document.getElementById('password').value;
    const messageDiv = document.getElementById('loginMessage');
    
    try {
        const data = await apiRequest('login.php', {
            method: 'POST',
            body: { email, password }
        });
        
        // Store user info in session storage
        sessionStorage.setItem('userId', data.user.id);
        sessionStorage.setItem('userName', data.user.name);
        sessionStorage.setItem('userEmail', data.user.email);
        sessionStorage.setItem('userRole', data.user.role);
        
        // Show success message and redirect
        messageDiv.className = 'alert alert-success';
        messageDiv.textContent = data.message;
        setTimeout(() => {
            window.location.href = 'dashboard.html';
        }, 1500);
        
    } catch (error) {
        messageDiv.className = 'alert alert-danger';
        messageDiv.textContent = error.message || 'Login failed. Please try again.';
    }
});

// Handle registration
document.getElementById('registerForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const name = document.getElementById('name').value;
    const email = document.getElementById('email').value;
    const password = document.getElementById('password').value;
    const role = document.getElementById('role').value;
    const messageDiv = document.getElementById('registerMessage');
    
    try {
        const data = await apiRequest('register.php', {
            method: 'POST',
            body: { name, email, password, role }
        });
        
        messageDiv.className = 'alert alert-success';
        messageDiv.textContent = data.message;
        setTimeout(() => {
            window.location.href = 'index.html';
        }, 2000);
        
    } catch (error) {
        messageDiv.className = 'alert alert-danger';
        messageDiv.textContent = error.message || 'Registration failed. Please try again.';
    }
});

// Handle logout
function logout() {
    apiRequest('logout.php', {
        method: 'POST'
    })
    .then(() => {
        sessionStorage.clear();
        window.location.href = 'index.html';
    })
    .catch(error => {
        console.error('Logout error:', error);
        // Still clear session and redirect even if API fails
        sessionStorage.clear();
        window.location.href = 'index.html';
    });
}